-- V2D - 12549 Messaging for APPOINTMENT Event

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPOINTMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'PERSON_TO_MEET_APPOINTMENT', 'Person To Meet Appointment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Person To Meet Appointment');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PERSON_TO_MEET_APPOINTMENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PERSON_TO_MEET_APPOINTMENT_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'PERSON_TO_MEET_APPOINTMENT_RECIPIENT');


-- SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
-- INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
-- VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,NULL,NULL);


-- Link Template data provider to message category

-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPOINTMENT');
-- SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
-- INSERT INTO `template_dtprovider`(`id`,`msgSubCategoryId`,`dataProviderId`,`dataProviderName`) VALUES (@templatedtproviderId+1,@msgSubCategoryId,@dtproviderId,'BULK_DOCUMENT_DOWNLOAD_TDP');


-- The under sql code gives for the user distribution list ,this information can be fetched

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"select T1.id as USER_ID from sg_appointment T1 where T1.id in(namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    staffs entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
WHERE
    T1.id IN (namedParams) 
UNION SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    students entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
WHERE
    T1.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 1
        },        
        {
            "id": 3,
            "value": "OUT_TIME",
            "resultKey": "OUT_TIME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },        
        {
            "id": 7,
            "value": "APPOINTMENT_DATE",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 6
        },        
        {
            "id": 8,
            "value": "printName",
            "resultKey": "CREATED_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },        
        {
            "id": 9,
            "value": "firstName",
            "resultKey": "CREATED_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 8
        },        
        {
            "id": 10,
            "value": "lastName",
            "resultKey": "CREATED_LAST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },        
        {
            "id": 11,
            "value": "appointeeName",
            "resultKey": "APPOINTEE_NAME",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
}');





-- Setting data in cb_dtprovider for the USER_UPDATE_LOGIN_CREDENTIAL_TDP ADDED

-- SET @cbdtproviderId=(SELECT MAX(id) FROM `cb_dtprovider`);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- insert  into `cb_dtprovider`(`id`,`dataProviderId`,`searchConfigCode`,`searchResultViewCode`) values (@cbdtproviderId+1, @dtproviderId,'BULK_DOCUMENT_DOWNLOAD_TDP','BULK_DOCUMENT_DOWNLOAD_TDP');




SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='PERSON_TO_MEET_APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Person To Meet Appointment',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Person To Meet Appointment',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Appointment Details','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">An appointment has been booked on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> From <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> To<strong> $recipientData[&quot;OUT_TIME&quot;]</strong></strong> with $recipientData[&quot;APPOINTEE_NAME&quot;].</span></span></p>
		
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.com/mailer/academiaerp-logo-red.png"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Appointment Details','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">An appointment has been booked on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> From <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> To<strong> $recipientData[&quot;OUT_TIME&quot;]</strong></strong> with $recipientData[&quot;APPOINTEE_NAME&quot;].</span></span></p>
		
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.com/mailer/academiaerp-logo-red.png"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Hello $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] An appointment has been booked on $recipientData[&quot;APPOINTMENT_DATE&quot;] From $recipientData[&quot;VISIT_TIME&quot;] To $recipientData[&quot;OUT_TIME&quot;] with $recipientData[&quot;APPOINTEE_NAME&quot;].');




-- End Messaging for APPOINTMENT Event
